<?php

/*
+--------------------------------------------------------------------------
|   Invision Power Board v1.2
|   ========================================
|   by Matthew Mecham
|   (c) 2001 - 2003 Invision Power Services
|   http://www.invisionpower.com
|   ========================================
|   Web: http://www.invisionboard.com
|   Email: matt@invisionpower.com
|   Licence Info: http://www.invisionboard.com/?license
+---------------------------------------------------------------------------
|
|   > Admin Forum functions
|   > Module written by Matt Mecham
|   > Date started: 17th March 2002
|
|	> Module Version Number: 1.0.0
+--------------------------------------------------------------------------
*/




$idx = new ad_groups();


class ad_groups {

	var $base_url;

	function ad_groups() {
		global $IN, $INFO, $DB, $SKIN, $ADMIN, $std, $MEMBER, $GROUP;
		
		//---------------------------------------
		// Kill globals - globals bad, Homer good.
		//---------------------------------------
		
		$tmp_in = array_merge( $_GET, $_POST, $_COOKIE );
		
		foreach ( $tmp_in as $k => $v )
		{
			unset($$k);
		}

		//---------------------------------------

		switch($IN['code'])
		{
			case 'doadd':
				$this->save_group('add');
				break;
				
			case 'add':
				$this->group_form('add');
				break;
				
			case 'edit':
				$this->group_form('edit');
				break;
			
			case 'doedit':
				$this->save_group('edit');
				break;
			
			case 'delete':
				$this->delete_form();
				break;
			
			case 'dodelete':
				$this->do_delete();
				break;
				
			//-------------------------	
				
			case 'fedit':
				$this->forum_perms();
				break;
				
			case 'pdelete':
				$this->delete_mask();
				break;
				
			case 'dofedit':
				$this->do_forum_perms();
				break;
						
			case 'permsplash':
				$this->permsplash();
				break;
				
			case 'view_perm_users':
				$this->view_perm_users();
				break;
					
			case 'remove_mask':
				$this->remove_mask();
				break;
				
			case 'preview_forums':
				$this->preview_forums();
				break;
				
			case 'dopermadd':
				$this->add_new_perm();
				break;
				
			case 'donameedit':
				$this->edit_name_perm();
				break;
			//-------------------------			
					
					
						
			default:
				$this->main_screen();
				break;
		}
		
	}
	
	//+---------------------------------------------------------------------------------
	//
	// Member group /forum mask permission form thingy doodle do yes. Viewing Perm users
	//
	//+---------------------------------------------------------------------------------
	
	function delete_mask()
	{
		global $IN, $INFO, $DB, $SKIN, $ADMIN, $std, $MEMBER, $GROUP;
		
		//+-------------------------------------------
		// Check for a valid ID
		//+-------------------------------------------
		
		if ($IN['id'] == "")
		{
			$ADMIN->error("޷Ȩ趨 ID");
		}
		
		$DB->query("DELETE FROM ibf_forum_perms WHERE perm_id='".$IN['id']."'");
		
		$old_id = intval($IN['id']);
		
		//+-------------------------------------------
		// Remove from forums...
		//+-------------------------------------------
		
		$get = $DB->query("SELECT id, read_perms, reply_perms, start_perms, upload_perms FROM ibf_forums");
				
		while( $f = $DB->fetch_row($get) )
		{
			$d_str = "";
			$d_arr = array();
			
			foreach( array( 'read_perms', 'reply_perms', 'start_perms', 'upload_perms' ) as $perm_bit )
			{
				if ($f[ $perm_bit ] != '*')
				{
					if ( preg_match( "/(^|,)".$old_id."(,|$)/", $f[ $perm_bit ]) )
					{
						$f[ $perm_bit ] = preg_replace( "/(^|,)".$old_id."(,|$)/", "\\1\\2", $f[ $perm_bit ] );
						
						$d_arr[ $perm_bit ] = $this->clean_perms( $f[ $perm_bit ] );
					}
				}
			}
			
			// Do we have anything to save?
				
			if ( count($d_arr) > 0 )
			{
				$d_str = $DB->compile_db_update_string( $d_arr );
				
				// Sure?..
				
				if ( strlen($d_str) > 5)
				{
					$save = $DB->query("UPDATE ibf_forums SET $d_str WHERE id={$f['id']}");
				}
			}
		}
		
		$this->permsplash();
	}
	
	//+---------------------------------------------------------------------------------
	
	
	function add_new_perm()
	{
		global $IN, $INFO, $DB, $SKIN, $ADMIN, $std, $MEMBER, $GROUP;
		
		$IN['new_perm_name'] = trim($IN['new_perm_name']);
		
		if ($IN['new_perm_name'] == "")
		{
			$ADMIN->error("You must enter a name");
		}
		
		$copy_id = $IN['new_perm_copy'];
		
		//+-------------------------------------------
		// UPDATE DB
		//+-------------------------------------------
		
		$DB->query("INSERT INTO ibf_forum_perms SET perm_name='".$IN['new_perm_name']."'");
		
		$new_id = $DB->get_insert_id();
		
		if ( $copy_id != 'none' )
		{
			//+-------------------------------------------
			// Add new mask to forum accesses
			//+-------------------------------------------
		
			$old_id = intval($copy_id);
			
			if ( ($new_id > 0) and ($old_id > 0) )
			{
				$get = $DB->query("SELECT id, read_perms, reply_perms, start_perms, upload_perms FROM ibf_forums");
				
				while( $f = $DB->fetch_row($get) )
				{
					$d_str = "";
					$d_arr = array();
					
					foreach( array( 'read_perms', 'reply_perms', 'start_perms', 'upload_perms' ) as $perm_bit )
					{
						if ($f[ $perm_bit ] != '*')
						{
							if ( preg_match( "/(^|,)".$old_id."(,|$)/", $f[ $perm_bit ]) )
							{
								$d_arr[ $perm_bit ] = $this->clean_perms( $f[ $perm_bit ] ) . ",".$new_id;
							}
						}
					}
					
					// Do we have anything to save?
						
					if ( count($d_arr) > 0 )
					{
						$d_str = $DB->compile_db_update_string( $d_arr );
						
						// Sure?..
						
						if ( strlen($d_str) > 5)
						{
							$save = $DB->query("UPDATE ibf_forums SET $d_str WHERE id={$f['id']}");
						}
					}
				}
			}
			
		
		}
		
		$this->permsplash();
			
		
	}
	
	//-_-_-_-_-_-_-_-_-
	//_-_-_-_-_-_-_-_-_
	//Now that's pretty
	
	function preview_forums()
	{
		global $IN, $INFO, $DB, $SKIN, $ADMIN, $std, $MEMBER, $GROUP;
		
		//+-------------------------------------------
		// Check for a valid ID
		//+-------------------------------------------
		
		if ($IN['id'] == "")
		{
			$ADMIN->error("޷Ȩ趨 ID");
		}
		
		
		$DB->query("SELECT * FROM ibf_forum_perms WHERE perm_id='".$IN['id']."'");
		
		if ( ! $perms = $DB->fetch_row() )
		{
			$ADMIN->error("޷Ȩ趨 ID");
		}
		
		//+-------------------------------------------
		// What we doin'?
		//+-------------------------------------------
		
		switch( $IN['t'] )
		{
			case 'start':
				$human_type = '';
				$code_word  = 'start_perms';
				break;
				
			case 'reply':
				$human_type = 'ظ';
				$code_word  = 'reply_perms';
				break;
				
			default:
				$human_type = '';
				$code_word  = 'read_perms';
				break;
		}
		
		//+-------------------------------------------
		// Get all members using that ID then!
		//+-------------------------------------------
		
		$SKIN->td_header[] = array( "$human_type" , "100%" );
		
		//+-------------------------------
		
		$ADMIN->html .= $SKIN->start_table( "Ԥʹã " . $perms['perm_name'] );
		
		$last_cat_id = -1;
		
		$DB->query("SELECT f.id as forum_id, f.parent_id, f.subwrap, f.sub_can_post, f.name as forum_name, f.position, f.read_perms, f.start_perms, f.reply_perms, c.id as cat_id, c.name
				    FROM ibf_forums f
				     LEFT JOIN ibf_categories c ON (c.id=f.category)
				    ORDER BY c.position, f.position");
		
		
		$forum_keys = array();
		$cat_keys   = array();
		$children   = array();
		$subs       = array();
		$the_html   = "";
		
		$perm_id    = intval($IN['id']);
		
		while ( $i = $DB->fetch_row() )
		{
			
			if ($i['subwrap'] == 1 and $i['sub_can_post'] != 1)
			{
				$forum_keys[ $i['cat_id'] ][$i['forum_id']] = "&nbsp;&nbsp;- {$i['forum_name']}\n";
			}
			else
			{
				if ($i[ $code_word ] == '*')
				{
					if ($i['parent_id'] > 0)
					{
						$children[ $i['parent_id'] ][] = "&nbsp;&nbsp;---- {$i['forum_name']}\n";
					}
					else
					{
						$forum_keys[ $i['cat_id'] ][$i['forum_id']] = "&nbsp;&nbsp;- {$i['forum_name']}\n";
					}
				}
				else if (preg_match( "/(^|,)".$perm_id."(,|$)/", $i[ $code_word ]) )
				{
					if ($i['parent_id'] > 0)
					{
						$children[ $i['parent_id'] ][] = "&nbsp;&nbsp;---- {$i['forum_name']}\n";
					}
					else
					{
						$forum_keys[ $i['cat_id'] ][$i['forum_id']] = "&nbsp;&nbsp;- {$i['forum_name']}\n";
					}
				}
				else
				{
					//-------------------------------------
					// CAN'T ACCESS
					//-------------------------------------
					
					if ($i['parent_id'] > 0)
					{
						$children[ $i['parent_id'] ][] = "<span style='color:gray'>&nbsp;&nbsp;---- {$i['forum_name']}</span>\n";
					}
					else
					{
						$forum_keys[ $i['cat_id'] ][$i['forum_id']] = "<span style='color:gray'>&nbsp;&nbsp;- {$i['forum_name']}</span>\n";
					}
				}
			}
			
			if ($last_cat_id != $i['cat_id'])
			{
				
				// Make sure cats with hidden forums are not shown in forum jump
				
				$cat_keys[ $i['cat_id'] ] = "<b>{$i['name']}</b>\n";
							              
				$last_cat_id = $i['cat_id'];
				
			}
		}
		
		foreach($cat_keys as $cat_id => $cat_text)
		{
			if ( is_array( $forum_keys[$cat_id] ) && count( $forum_keys[$cat_id] ) > 0 )
			{
				$the_html .= $cat_text;
				
				foreach($forum_keys[$cat_id] as $idx => $forum_text)
				{
					$the_html .= $forum_text;
					
					if (count($children[$idx]) > 0)
					{
						foreach($children[$idx] as $ii => $tt)
						{
							$the_html .= $tt;
						}
					}
				}
			}
		}
		
		$the_html = str_replace( "\n", "<br />\n", $the_html );
		
		$ADMIN->html .= $SKIN->add_td_row( array( $the_html )      );
		
		$ADMIN->html .= $SKIN->end_table();
		
		//----------------------------------------------------------------------------------------
		
		$ADMIN->html .= $SKIN->start_form( array( 1 => array( 'code'  , 'preview_forums' ),
												  2 => array( 'act'   , 'group'   ),
												  3 => array( 'id'    , $IN['id']      ),
									     )      );
		
		$SKIN->td_header[] = array( "&nbsp;" , "60%" );
		$SKIN->td_header[] = array( "&nbsp;" , "40%" );
		
		$ADMIN->html .= $SKIN->start_table( "Legend & Info" );
		
		$ADMIN->html .= $SKIN->add_td_row( array(
													"ڴ $human_type",
													"<input type='text' readonly='readonly' style='border:1px solid black;background-color:black;size=30px' name='blah'>"
										 )      );
										 
		$ADMIN->html .= $SKIN->add_td_row( array(
													"ڴ $human_type",
													"<input type='text' readonly='readonly' style='border:1px solid gray;background-color:gray;size=30px' name='blah'>"
										 )      );
										 
		$ADMIN->html .= $SKIN->add_td_row( array(
													"Test with...",
													$SKIN->form_dropdown( 't',
																		array( 0 => array( 'start', ''    ),
																			   1 => array( 'reply', 'ظ' ),
																			   2 => array( 'read' , 'ȡ'      ),
																			  ), $IN['t'] )
										 )      );
										 
		$ADMIN->html .= $SKIN->end_form( "" );
		
		$ADMIN->html .= $SKIN->end_table();
		
		$ADMIN->print_popup();
							   
	}
	
	//===========================================================================
	
	function remove_mask()
	{
		global $IN, $INFO, $DB, $SKIN, $ADMIN, $std, $MEMBER, $GROUP;
		
		//+-------------------------------------------
		// Check for a valid ID
		//+-------------------------------------------
		
		if ($IN['id'] == "")
		{
			$ADMIN->error("޷ûԱ ID");
		}
		
		//+-------------------------------------------
		// Get, check and reset
		//+-------------------------------------------
		
		$DB->query("SELECT uid, uname, org_perm_id FROM ibf_members WHERE uid=".intval($IN['id']));
		
		if ( ! $mem = $DB->fetch_row() )
		{
			$ADMIN->error("޷ûԱ ID");
		}
		
		if ( $IN['pid'] == 'all' )
		{
			$DB->query("UPDATE ibf_members SET org_perm_id=0 WHERE uid=".intval($IN['id']));
		}
		else
		{
			$IN['pid'] = intval($IN['pid']);
			
			$pid_array = explode( ",", $mem['org_perm_id'] );
			
			if ( count($pid_array) < 2 )
			{
				$DB->query("UPDATE ibf_members SET org_perm_id=0 WHERE uid=".intval($IN['id']));
			}
			else
			{
				$new_arr = array();
				
				foreach( $pid_array as $sid )
				{
					if ( $sid != $IN['pid'] )
					{
						$new_arr[] = $sid;
					}
				}
				
				$DB->query("UPDATE ibf_members SET org_perm_id='".implode(",",$new_arr)."' WHERE id=".intval($IN['id']));
			}	
			
		}
			
		//+-------------------------------------------
		// Get all members using that ID then!
		//+-------------------------------------------
		
		$SKIN->td_header[] = array( "&nbsp;" , "100%" );
		
		//+-------------------------------
		
		$ADMIN->html .= $SKIN->start_table( "" );
		
		
		
		$ADMIN->html .= $SKIN->add_td_row( array( " <b>{$mem['uname']}</b> ƳԶȨ趨",
										 )      );
	
		$ADMIN->html .= $SKIN->end_table();
		
		$ADMIN->print_popup();
							   
	}
	
	//===========================================================================
	
	
	function view_perm_users()
	{
		global $IN, $INFO, $DB, $SKIN, $ADMIN, $std, $MEMBER, $GROUP;
		
		//+-------------------------------------------
		// Check for a valid ID
		//+-------------------------------------------
		
		if ($IN['id'] == "")
		{
			$ADMIN->error("޷Ȩ趨 ID");
		}
		
		
		$DB->query("SELECT * FROM ibf_forum_perms WHERE perm_id='".$IN['id']."'");
		
		if ( ! $perms = $DB->fetch_row() )
		{
			$ADMIN->error("޷Ȩ趨 ID");
		}
		
		//+-------------------------------------------
		// Get all members using that ID then!
		//+-------------------------------------------
		
		$SKIN->td_header[] = array( "ʹ" , "50%" );
		$SKIN->td_header[] = array( ""       , "50%" );
		
		//+-------------------------------
		
		$ADMIN->html .= "<script language='javascript' type='text/javascript'>
						 <!--
						  function pop_close_and_stop( id )
						  {
						  	opener.location = \"{$SKIN->base_url}&act=mem&code=doform&MEMBER_ID=\" + id;
						  	self.close();
						  }
						  //-->
						  </script>";
		
		//+-------------------------------
		
		$ADMIN->html .= $SKIN->start_table( "Աʹã " . $perms['perm_name'] );
		
		$outer = $DB->query("SELECT uid, uname, email, posts, org_perm_id FROM ibf_members WHERE (org_perm_id IS NOT NULL AND org_perm_id <> 0) ORDER BY uname");
		
		while( $r = $DB->fetch_row($outer) )
		{
			$exp_pid = explode( ",", $r['org_perm_id'] );
			
			foreach( explode( ",", $r['org_perm_id'] ) as $pid )
			{
				if ( $pid == $IN['id'] )
				{
					if ( count($exp_pid) > 1 )
					{
						$extra = "<li>Also using: <em style='color:red'>";
						
						$DB->query("SELECT * FROM ibf_forum_perms WHERE perm_id IN ({$r['org_perm_id']}) AND perm_id <> {$IN['id']}");
						
						while ( $mr = $DB->fetch_row() )
						{
							$extra .= $mr['perm_name'].",";
						}
						
						$extra = preg_replace( "/,$/", "", $extra );
						
						$extra .= "</em>";
					}
					else
					{
						$extra = "";
					}
					
					$ADMIN->html .= $SKIN->add_td_row( array( "<div style='font-weight:bold;font-size:11px;padding-bottom:6px;margin-bottom:3px;border-bottom:1px solid #000'>{$r['uname']}</div>
															   <li>£ {$r['posts']}
															   <li>ʼ {$r['email']}
															   $extra" ,
															  "&#149;&nbsp;<a href='{$SKIN->base_url}&amp;act=group&amp;code=remove_mask&amp;id={$r['uid']}&amp;pid=$pid' title='ӸʹƳ趨 (ӵж趨ȫƳ'>Ƴ趨</a>
															   <br />&#149;&nbsp;<a href='{$SKIN->base_url}&amp;act=group&amp;code=remove_mask&amp;id={$r['uid']}&amp;pid=all' title='Ƴȫʹ趨'>Ƴȫ趨</a>
															   <br /><br />&#149;&nbsp;<a href='javascript:pop_close_and_stop(\"{$r['uid']}\");'>༭Ա</a>",
													 )      );
				}
			}
		}
		
						     
		$ADMIN->html .= $SKIN->end_table();
		
		$ADMIN->print_popup();
							   
	}
	
	
	//+---------------------------------------------------------------------------------
	//
	// Member group /forum mask permission form thingy doodle do yes.
	//
	//+---------------------------------------------------------------------------------
	
	
	function permsplash()
	{
		global $IN, $INFO, $DB, $SKIN, $ADMIN, $std, $MEMBER, $GROUP;
		
		$ADMIN->page_title = "Ȩ趨 [ ҳ ]";
		
		$ADMIN->page_detail = "Ȩ趨";
		
		$ADMIN->page_detail .= "<br /><b>ʹȺ</b> ԱȺʹõȨ趨й
								<br /><b>ʹûԱ</b> 趨ԴȨ趨ȺʹõȨ趨Ա
							    <br /><b>Ԥ</b> һֿ١ĸʽԤ趨ɴȡ
							   ";
								
		
		//+-------------------------------------------
		// Get the names for the perm masks w/id
		//+-------------------------------------------
		
		$perms = array();
		
		$DB->query("SELECT * FROM ibf_forum_perms");
		
		while( $r = $DB->fetch_row() )
		{
			$perms[ $r['perm_id'] ] = $r['perm_name'];
		}
		
		//+-------------------------------------------
		// Get the number of members using this mask
		// as an over ride
		//+-------------------------------------------
		
		$mems = array();
		
		$DB->query("SELECT COUNT(uid) as count, org_perm_id FROM ibf_members WHERE (org_perm_id IS NOT NULL AND org_perm_id <> 0) GROUP by org_perm_id");
		
		while( $r = $DB->fetch_row() )
		{
			if ( strstr($r['org_perm_id'] , "," ) )
			{
				foreach( explode( ",", $r['org_perm_id'] ) as $pid )
				{
					$mems[ $pid ] += $r['count'];
				}
			}
			else
			{
				$mems[ $r['org_perm_id'] ] += $r['count'];
			}
		}
		
		//+-------------------------------------------
		// Get the member group names and the mask
		// they use
		//+-------------------------------------------
		
		$groups = array();
		
		$DB->query("SELECT g_id, g_title, g_perm_id FROM ibf_groups");
		
		while( $r = $DB->fetch_row() )
		{
			if ( strstr($r['g_perm_id'] , "," ) )
			{
				foreach( explode( ",", $r['g_perm_id'] ) as $pid )
				{
					$groups[ $pid ][] = $r['g_title'];
				}
			}
			else
			{
				$groups[ $r['g_perm_id'] ][] = $r['g_title'];
			}
		}
		
		//+-------------------------------------------
		// Print the splash screen
		//+-------------------------------------------
		
		$SKIN->td_header[] = array( "趨"          , "20%" );
		$SKIN->td_header[] = array( "ʹȺ"   , "20%" );
		$SKIN->td_header[] = array( "ʹûԱ"     , "20%" );
		$SKIN->td_header[] = array( "Ԥ"            , "10%" );
		$SKIN->td_header[] = array( "༭"               , "15%" );
		$SKIN->td_header[] = array( "ɾ"             , "15%" );
		
		//+-------------------------------
		
		$ADMIN->html .= $SKIN->js_pop_win();
		
		//+-------------------------------
		
		$ADMIN->html .= $SKIN->start_table( "Ȩ趨" );
		
		foreach( $perms as $id => $name )
		{
			$groups_used = "";
			
			$is_active = 0;
			
			if ( is_array( $groups[ $id ] ) )
			{
				foreach( $groups[ $id ] as $bleh => $g_title )
				{
					$groups_used .= $g_title . "<br />";
				}
				
				$is_active = 1;
				
			}
			else
			{
				$groups_used = "<center><i></i></center>";
			}
			
			$mems_used = 0;
			
			if ( $mems[ $id ] > 0 )
			{
				$is_active = 1;
				$mems_used = $mems[ $id ] . " (<a href='javascript:pop_win(\"&amp;act=group&amp;code=view_perm_users&amp;id=$id\", \"User\", \"500\",\"350\");' title='Ӵʹô趨ĻԱ'></a>)";
			}
			
			if ( $is_active > 0 )
			{
				$delete = "<i>Уʹ</i>";
			}
			else
			{
				$delete = "<a href='{$SKIN->base_url}&amp;act=group&amp;code=pdelete&amp;id=$id'>ɾ</a>";
			}
			
			$ADMIN->html .= $SKIN->add_td_row( array( "<b>$name</b>" ,
													  "$groups_used",
													  "<center>$mems_used</center>",
													  "<center><a href='javascript:pop_win(\"&amp;act=group&amp;code=preview_forums&amp;id=$id&amp;t=read\", \"400\",\"350\");' title='Ⱥܿ..'>Ԥ</a></center>",
													  "<center><a href='{$SKIN->base_url}&amp;act=group&amp;code=fedit&amp;id=$id'>༭</a></center>",
													  "<center>$delete</center>",
											 )      );
		
		}
		
		$ADMIN->html .= $SKIN->end_table();
		
		//+-------------------------------
		
		$dlist = array();
		
		$dlist[] = array( 'none', 'Ҫ̳' );
		
		foreach( $perms as $id => $name )
		{
			$dlist[] = array( $id, $name );
		}
		
		$ADMIN->html .= $SKIN->start_form( array( 1 => array( 'code'  , 'dopermadd' ),
												  2 => array( 'act'   , 'group'   ),
									     )      );
									     
		
		$SKIN->td_header[] = array( "{none}" , "60%" );
		$SKIN->td_header[] = array( "{none}" , "40%" );
		
		//+-------------------------------
		
		$ADMIN->html .= $SKIN->start_table( "µȨ趨" );
		
		$ADMIN->html .= $SKIN->add_td_row( array( "<b>Ȩ趨</b>" ,
												  $SKIN->form_input( 'new_perm_name' ),
										 )      );
										 
		$ADMIN->html .= $SKIN->add_td_row( array( "<b>̳Ȩ趨...</b>" ,
												 $SKIN->form_dropdown( 'new_perm_copy', $dlist ),
										 )      );
		
		$ADMIN->html .= $SKIN->end_form("");
						     
		$ADMIN->html .= $SKIN->end_table();
		
		
		
		$ADMIN->output();
			
			
	}
	
	
	
	function forum_perms()
	{
		global $IN, $INFO, $DB, $SKIN, $ADMIN, $std, $MEMBER, $GROUP;
		
		if ($IN['id'] == "")
		{
			$ADMIN->error("޷Ⱥ ID");
		}
		
		//+----------------------------------
		
		$ADMIN->page_title = "Ȩ趨 [ ༭ ]";
		
		$ADMIN->page_detail = "Ȩ趨";
		
		$ADMIN->page_detail .= "<br />ȡöȨޣѡֹöȨޡ
							   <br /><b></b> ʾִ漰δȨ趨ɽиö޷ı䡣";
		
		//+----------------------------------
		
		$DB->query("SELECT * FROM ibf_forum_perms WHERE perm_id='".$IN['id']."'");
		
		$group = $DB->fetch_row();
		
		$gid   = $group['perm_id'];
		$gname = $group['perm_name'];
		
		//+-------------------------------
		
		$cats     = array();
		$forums   = array();
		$children = array();
		
		$DB->query("SELECT * from ibf_categories WHERE id > 0 ORDER BY position ASC");
		
		while ($r = $DB->fetch_row())
		{
			$cats[$r['id']] = $r;
		}
		
		$DB->query("SELECT * from ibf_forums ORDER BY position ASC");
		
		while ($r = $DB->fetch_row())
		{
			
			if ($r['parent_id'] > 0)
			{
				$children[ $r['parent_id'] ][] = $r;
			}
			else
			{
				$forums[] = $r;
			}
			
		}
		
		//+----------------------------------
		//| EDIT NAME
		//+----------------------------------
		
		$ADMIN->html .= $SKIN->start_form( array( 1 => array( 'code'  , 'donameedit' ),
												  2 => array( 'act'   , 'group'   ),
												  3 => array( 'id'    , $gid      ),
									     )      );
		
		$SKIN->td_header[] = array( "&nbsp;"   , "40%" );
		$SKIN->td_header[] = array( "&nbsp;"   , "60%" );
		
		$ADMIN->html .= $SKIN->start_table( "Ⱥ飺 ".$group['perm_name'] );
		
		$ADMIN->html .= $SKIN->add_td_row( array( "<b>趨</b>" ,
												  $SKIN->form_input("perm_name", $gname )
									     )      );
									     
		$ADMIN->html .= $SKIN->end_form("༭");
		
		$ADMIN->html .= $SKIN->end_table();
		
		
		//+----------------------------------
		//| MAIN FORM
		//+----------------------------------
		
		$ADMIN->html .= $SKIN->start_form( array( 1 => array( 'code'  , 'dofedit' ),
												  2 => array( 'act'   , 'group'   ),
												  3 => array( 'id'    , $gid      ),
									     )      );
		
		$SKIN->td_header[] = array( ""   , "40%" );
		$SKIN->td_header[] = array( "ȡ"         , "15%" );
		$SKIN->td_header[] = array( "ظ"        , "15%" );
		$SKIN->td_header[] = array( ""        , "15%" );
		$SKIN->td_header[] = array( "ϴ"       , "15%" );
		
		$ADMIN->html .= $SKIN->start_table( $group['perm_name']." ȡȨ" );
		
		$last_cat_id = -1;
		
		foreach ($cats as $c)
		{
			
			$ADMIN->html .= $SKIN->add_td_basic( $c['name'], 'left', 'catrow' );
													   
			$last_cat_id = $c['id'];
			
			
			foreach($forums as $r)
			{	
			
				if ($r['category'] == $last_cat_id)
				{
				
					$read   = "";
					$start  = "";
					$reply  = "";
					$upload = "";
					$global = '<center id="mgblue"><i></i></center>';
					
					if ($r['read_perms'] == '*')
					{
						$read = $global;
					}
					else if ( preg_match( "/(^|,)".$gid."(,|$)/", $r['read_perms'] ) )
					{
						$read = "<center id='mgblue'><input type='checkbox' name='read_".$r['id']."' value='1' checked></center>";
					}
					else
					{
						$read = "<center id='mgblue'><input type='checkbox' name='read_".$r['id']."' value='1'></center>";
					}
					
					//---------------------------
					
					$global = '<center id="mgred"><i></i></center>';
					
					if ($r['start_perms'] == '*')
					{
						$start = $global;
					}
					else if ( preg_match( "/(^|,)".$gid."(,|$)/", $r['start_perms'] ) )
					{
						$start = "<center id='mgred'><input type='checkbox' name='start_".$r['id']."' value='1' checked></center>";
					}
					else
					{
						$start = "<center id='mgred'><input type='checkbox' name='start_".$r['id']."' value='1'></center>";
					}
					
					//---------------------------
					
					$global = '<center id="mggreen"><i></i></center>';
					
					if ($r['reply_perms'] == '*')
					{
						$reply = $global;
					}
					else if ( preg_match( "/(^|,)".$gid."(,|$)/", $r['reply_perms'] ) )
					{
						$reply = "<center id='mggreen'><input type='checkbox' name='reply_".$r['id']."' value='1' checked></center>";
					}
					else
					{
						$reply = "<center id='mggreen'><input type='checkbox' name='reply_".$r['id']."' value='1'></center>";
					}
					
					//---------------------------
					
					$global = '<center id="memgroup"><i></i></center>';
					
					if ($r['upload_perms'] == '*')
					{
						$upload = $global;
					}
					else if ( preg_match( "/(^|,)".$gid."(,|$)/", $r['upload_perms'] ) )
					{
						$upload = "<center id='memgroup'><input type='checkbox' name='upload_".$r['id']."' value='1' checked></center>";
					}
					else
					{
						$upload = "<center id='memgroup'><input type='checkbox' name='upload_".$r['id']."' value='1'></center>";
					}
					
					//---------------------------
					
					if ($r['subwrap'] == 1 and $r['sub_can_post'] != 1)
					{
						$ADMIN->html .= $SKIN->add_td_basic( "&gt; ".$r['name'], 'left', 'catrow2' );
					}
					else
					{
						$css = $r['subwrap'] == 1 ? 'catrow2' : '';
						
						$ADMIN->html .= $SKIN->add_td_row( array(
															   "<b> - ".$r['name']."</b>",
															   $read,
															   $reply,
															   $start,
															   $upload
													 )   , $css   );
					}
													 
					if ( ( isset($children[ $r['id'] ]) ) and ( count ($children[ $r['id'] ]) > 0 ) )
					{
						foreach($children[ $r['id'] ] as $idx => $rd)
						{
							$read   = "";
							$start  = "";
							$reply  = "";
							$upload = "";
							$global = "<center id='mgblue'><i></i></center>";
							
							if ($rd['read_perms'] == '*')
							{
								$read = $global;
							}
							else if ( preg_match( "/(^|,)".$gid."(,|$)/", $rd['read_perms'] ) )
							{
								$read = "<center id='mgblue'><input type='checkbox' name='read_".$rd['id']."' value='1' checked></center>";
							}
							else
							{
								$read = "<center id='mgblue'><input type='checkbox' name='read_".$rd['id']."' value='1'></center>";
							}
							
							//---------------------------
							
							$global = "<center id='mgred'><i></i></center>";
							
							if ($rd['start_perms'] == '*')
							{
								$start = $global;
							}
							else if ( preg_match( "/(^|,)".$gid."(,|$)/", $rd['start_perms'] ) )
							{
								$start = "<center id='mgred'><input type='checkbox' name='start_".$rd['id']."' value='1' checked></center>";
							}
							else
							{
								$start = "<center id='mgred'><input type='checkbox' name='start_".$rd['id']."' value='1'></center>";
							}
							
							//---------------------------
							
							$global = "<center id='mggreen'><i></i></center>";
							
							if ($rd['reply_perms'] == '*')
							{
								$reply = $global;
							}
							else if ( preg_match( "/(^|,)".$gid."(,|$)/", $rd['reply_perms'] ) )
							{
								$reply = "<center id='mggreen'><input type='checkbox' name='reply_".$rd['id']."' value='1' checked></center>";
							}
							else
							{
								$reply = "<center id='mggreen'><input type='checkbox' name='reply_".$rd['id']."' value='1'></center>";
							}
							
							//---------------------------
							
							$global = "<center id='memgroup'><i></i></center>";
							
							if ($rd['upload_perms'] == '*')
							{
								$upload = $global;
							}
							else if ( preg_match( "/(^|,)".$gid."(,|$)/", $rd['upload_perms'] ) )
							{
								$upload = "<center id='memgroup'><input type='checkbox' name='upload_".$rd['id']."' value='1' checked></center>";
							}
							else
							{
								$upload = "<center id='memgroup'><input type='checkbox' name='upload_".$rd['id']."' value='1'></center>";
							}
							
							//---------------------------
					
							$ADMIN->html .= $SKIN->add_td_row( array(
															   "<b> --- ".$rd['name']."</b>",
															   $read,
															   $reply,
															   $start,
															   $upload
													 ) , 'subforum'     );
						}
					}					 
				}
			}
		}
		
		$ADMIN->html .= $SKIN->end_form("Ȩ");
		
		$ADMIN->html .= $SKIN->end_table();
		
		$ADMIN->output();
		
	}
	
	
	function edit_name_perm()
	{
		global $IN, $INFO, $DB, $SKIN, $ADMIN, $std, $MEMBER, $GROUP;
		
		//---------------------------
		// Check for legal ID
		//---------------------------
		
		if ($IN['id'] == "")
		{
			$ADMIN->error("޷Ⱥ ID");
		}
		
		if ( $IN['perm_name'] == "" )
		{
			$ADMIN->error("һ");
		}
		
		$gid = $IN['id'];
		
		//---------------------------
		
		$DB->query("SELECT * FROM ibf_forum_perms WHERE perm_id='".$IN['id']."'");
		
		if ( ! $gr = $DB->fetch_row() )
		{
			$ADMIN->error("ЧȺ ID");
		}
		
		$DB->query("UPDATE ibf_forum_perms SET perm_name='{$IN['perm_name']}' WHERE perm_id='".$IN['id']."'");
		
		$ADMIN->save_log("ѱ༭ȡȨƵ趨 '{$gr['perm_name']}'");
		
		$ADMIN->done_screen("ѸȡȨ", "Ȩ趨", "act=group&code=permsplash" );
		
		
	}
	
	
	
	function do_forum_perms()
	{
		global $IN, $INFO, $DB, $SKIN, $ADMIN, $std, $MEMBER, $GROUP;
		
		//---------------------------
		// Check for legal ID
		//---------------------------
		
		if ($IN['id'] == "")
		{
			$ADMIN->error("޷Ⱥ ID");
		}
		
		$gid = $IN['id'];
		
		//---------------------------
		
		$DB->query("SELECT * FROM ibf_forum_perms WHERE perm_id='".$IN['id']."'");
		
		if ( ! $gr = $DB->fetch_row() )
		{
			$ADMIN->error("ЧȺ ID");
		}
		
		//---------------------------
		// Pull the forum data..
		//---------------------------
		
		$forum_q = $DB->query("SELECT id, read_perms, start_perms, reply_perms, upload_perms FROM ibf_forums ORDER BY position ASC");
		
		while ( $row = $DB->fetch_row( $forum_q ) )
		{
		
			$read  = "";
			$reply = "";
			$start = "";
			$upload = "";
			//---------------------------
			// Is this global?
			//---------------------------
			
			if ($row['read_perms'] == '*')
			{
				$read = '*';
				
			}
			else
			{
				//---------------------------
				// Split the set IDs
				//---------------------------
				
				$read_ids = explode( ",", $row['read_perms'] );
				
				if ( is_array($read_ids) )
				{
				   foreach ($read_ids as $i)
				   {
					   //---------------------------
					   // If it's the current ID, skip
					   //---------------------------
					   
					   if ($gid == $i)
					   {
						   continue;
					   }
					   else
					   {
						   $read .= $i.",";
					   }
				   }
				}
				//---------------------------
				// Was the box checked?
				//---------------------------
				
				if ($IN[ 'read_'.$row['id'] ] == 1)
				{
					// Add our group ID...
					
					$read .= $gid.",";
				}
				
				// Tidy..
				
				$read = preg_replace( "/,$/", "", $read );
				$read = preg_replace( "/^,/", "", $read );
				
			}
			
			//---------------------------
			// Reply topics..
			//---------------------------
				
			if ($row['reply_perms'] == '*')
			{
				$reply = '*';
			}
			else
			{
				$reply_ids = explode( ",", $row['reply_perms'] );
				
				if ( is_array($reply_ids) )
				{
				
					foreach ($reply_ids as $i)
					{
						if ($gid == $i)
						{
							continue;
						}
						else
						{
							$reply .= $i.",";
						}
					}
				
				}
				
				if ($IN[ 'reply_'.$row['id'] ] == 1)
				{
					$reply .= $gid.",";
				}
				
				$reply = preg_replace( "/,$/", "", $reply );
				$reply = preg_replace( "/^,/", "", $reply );
			}
			
			//---------------------------
			// Start topics..
			//---------------------------
				
			if ($row['start_perms'] == '*')
			{
				$start = '*';
			}
			else
			{
				$start_ids = explode( ",", $row['start_perms'] );
				
				if ( is_array($start_ids) )
				{
				
					foreach ($start_ids as $i)
					{
						if ($gid == $i)
						{
							continue;
						}
						else
						{
							$start .= $i.",";
						}
					}
				
				}
				
				if ($IN[ 'start_'.$row['id'] ] == 1)
				{
					$start .= $gid.",";
				}
				
				$start = preg_replace( "/,$/", "", $start );
				$start = preg_replace( "/^,/", "", $start );
			}
			
			//---------------------------
			// Upload topics..
			//---------------------------
				
			if ($row['upload_perms'] == '*')
			{
				$upload = '*';
			}
			else
			{
				$upload_ids = explode( ",", $row['upload_perms'] );
				
				if ( is_array($upload_ids) )
				{
				
					foreach ($upload_ids as $i)
					{
						if ($gid == $i)
						{
							continue;
						}
						else
						{
							$upload .= $i.",";
						}
					}
				
				}
				
				if ($IN[ 'upload_'.$row['id'] ] == 1)
				{
					$upload .= $gid.",";
				}
				
				$upload = preg_replace( "/,$/", "", $upload );
				$upload = preg_replace( "/^,/", "", $upload );
			}
			
			//---------------------------
			// Update the DB...
			//---------------------------
			
			if (! $new_q = $DB->query("UPDATE ibf_forums SET read_perms='$read', reply_perms='$reply', start_perms='$start', upload_perms='$upload' WHERE id='".$row['id']."'") )
			{
				die ("²ѯʧ ID ".$row['id']);
			}
			
		}
		
		$ADMIN->save_log("ѱ༭趨 '{$gr['perm_name']}' ȡȨ");
		
		$ADMIN->done_screen("ѸȨ趨", "Ȩ趨", "act=group&code=permsplash" );
		
	}
	
	//+---------------------------------------------------------------------------------
	//
	// Delete a group
	//
	//+---------------------------------------------------------------------------------
	
	function delete_form()
	{
		global $IN, $INFO, $DB, $SKIN, $ADMIN, $std, $MEMBER, $GROUP;
		
		if ($IN['id'] == "")
		{
			$ADMIN->error("޷Ⱥ ID");
		}
		
		if ($IN['id'] < 5)
		{
			$ADMIN->error("ƳԤȺ飬ֻܸ༭Ȩ޻");
		}
		
		$ADMIN->page_title = "ɾһʹȺ";
		
		$ADMIN->page_detail = "ȷ׼ƳȺ";
		
		
		//+-------------------------------
		
		$DB->query("SELECT COUNT(uid) as users FROM ibf_members WHERE mgroup='".$IN['id']."'");
		$black_adder = $DB->fetch_row();
		
		if ($black_adder['users'] < 1)
		{
			$black_adder['users'] = 0;
		}
		
		$DB->query("SELECT g_title FROM ibf_groups WHERE g_id='".$IN['id']."'");
		$group = $DB->fetch_row();
		
		//+-------------------------------
		
		$DB->query("SELECT g_id, g_title FROM ibf_groups WHERE g_id <> '".$IN['id']."'");
		
		$mem_groups = array();
		
		while ( $r = $DB->fetch_row() )
		{
			$mem_groups[] = array( $r['g_id'], $r['g_title'] );
		}
		
		//+-------------------------------
		
		$ADMIN->html .= $SKIN->start_form( array( 1 => array( 'code'  , 'dodelete'  ),
												  2 => array( 'act'   , 'group'     ),
												  3 => array( 'id'    , $IN['id']   ),
												  4 => array( 'name'  , $group['g_title'] ),
									     )      );
									     
		
		
		//+-------------------------------
		
		$SKIN->td_header[] = array( "&nbsp;"  , "40%" );
		$SKIN->td_header[] = array( "&nbsp;"  , "60%" );
		
		//+-------------------------------
		
		$ADMIN->html .= $SKIN->start_table( "Ƴȷϣ ".$group['g_title'] );
		
		$ADMIN->html .= $SKIN->add_td_row( array( "<b>Ⱥʹ</b>" ,
												  "<b>".$black_adder['users']."</b>",
									     )      );
									     
		$ADMIN->html .= $SKIN->add_td_row( array( "<b>Ⱥʹߵ...</b>" ,
												  $SKIN->form_dropdown("to_id", $mem_groups )
									     )      );
		
		$ADMIN->html .= $SKIN->end_form("ɾȺ");
										 
		$ADMIN->html .= $SKIN->end_table();
		
		$ADMIN->output();
			
	}
	
	function do_delete()
	{
		global $IN, $INFO, $DB, $SKIN, $ADMIN, $std, $MEMBER, $GROUP;
		
		if ($IN['id'] == "")
		{
			$ADMIN->error("޷Ⱥ ID, ");
		}
		
		if ($IN['to_id'] == "")
		{
			$ADMIN->error("ûָҪȺ ID /ҿˣء");
		}
		
		// Check to make sure that the relevant groups exist.
		
		$DB->query("SELECT g_id FROM ibf_groups WHERE g_id IN(".$IN['id'].",".$IN['to_id'].")");
		
		if ( $DB->get_num_rows() != 2 )
		{
			$ADMIN->error("޷ IDȺɾ");
		}
		
		$DB->query("UPDATE ibf_members SET mgroup='".$IN['to_id']."' WHERE mgroup='".$IN['id']."'");
		
		$DB->query("DELETE FROM ibf_groups WHERE g_id='".$IN['id']."'");
		
		// Look for promotions in case we have members to be promoted to this group...
		
		$prq = $DB->query("SELECT g_id FROM ibf_groups WHERE g_promotion LIKE '{$IN['id']}&%'");
		
		while ( $row = $DB->fetch_row($prq) )
		{
			$nq = $DB->query("UPDATE ibf_groups SET g_promotion='-1&-1' WHERE g_id='".$row['g_id']."'");
		}
		
		// Remove from moderators table
		
		$DB->query("DELETE FROM ibf_moderators WHERE is_group=1 AND group_id=".$IN['id']);
		
		$ADMIN->save_log("ƳԱȺ '{$IN['name']}'");
		
		$ADMIN->done_screen("ƳȺ", "Ⱥ", "act=group" );
		
	}
	
	
	//+---------------------------------------------------------------------------------
	//
	// Save changes to DB
	//
	//+---------------------------------------------------------------------------------
	
	function save_group($type='edit')
	{
		global $IN, $INFO, $DB, $SKIN, $ADMIN, $std, $MEMBER, $GROUP, $HTTP_POST_VARS;
		
		if ($IN['g_title'] == "")
		{
			$ADMIN->error("һȺ");
		}
		
		if ($type == 'edit')
		{
			if ($IN['id'] == "")
			{
				$ADMIN->error("޷Ⱥ id");
			}
			
			if ($IN['id'] == $INFO['admin_group'] and $IN['g_access_cp'] != 1)
			{
				$ADMIN->error("ƳȺ̨Ȩ");
			}
		}
		
		//------------------------------------
		// Sort out the perm mask id things
		//------------------------------------
		
		if ( is_array( $HTTP_POST_VARS['permid'] ) )
		{
			$perm_id = implode( ",", $HTTP_POST_VARS['permid'] );
		}
		else
		{
			$ADMIN->error("δѡȨ趨");
		}
		
		// Build up the hashy washy for the database ..er.. wase.
		
		$prefix = preg_replace( "/'/", "'" , stripslashes($HTTP_POST_VARS['prefix']) );
		$prefix = preg_replace( "/&lt;/" , "<" , $prefix          );
		$suffix = preg_replace( "/'/", "'" , stripslashes($HTTP_POST_VARS['suffix']) );
		$suffix = preg_replace( "/&lt;/" , "<" , $suffix          );
		
		$promotion_a = '-1'; //id
		$promotion_b = '-1'; // posts
		
		if ($IN['g_promotion_id'] > 0)
		{
			$promotion_a = $IN['g_promotion_id'];
			$promotion_b = $IN['g_promotion_posts'];
		}
		
		//if ($IN['g_max_messages'] == 0)
		//{
			//$IN['g_max_messages'] = -1;
		//}
		
		//list($p_max, $p_width, $p_height) = explode( ":", $group['g_photo_max_vars'] );
		
		$IN['p_max']    = str_replace( ":", "", $IN['p_max'] );
		$IN['p_width']  = str_replace( ":", "", $IN['p_width'] );
		$IN['p_height'] = str_replace( ":", "", $IN['p_height'] );
		
		$db_string = array(
							 'g_view_board'         => $IN['g_view_board'],
							 'g_mem_info'           => $IN['g_mem_info'],
							 'g_other_topics'       => $IN['g_other_topics'],
							 'g_use_search'         => $IN['g_use_search'],
							 'g_email_friend'       => $IN['g_email_friend'],
							 'g_invite_friend'      => $IN['g_invite_friend'],
							 'g_edit_profile'       => $IN['g_edit_profile'],
							 'g_post_new_topics'    => $IN['g_post_new_topics'],
							 'g_reply_own_topics'   => $IN['g_reply_own_topics'],
							 'g_reply_other_topics' => $IN['g_reply_other_topics'],
							 'g_edit_posts'         => $IN['g_edit_posts'],
							 'g_edit_cutoff'        => $IN['g_edit_cutoff'],
							 'g_delete_own_posts'   => $IN['g_delete_own_posts'],
							 'g_open_close_posts'   => $IN['g_open_close_posts'],
							 'g_delete_own_topics'  => $IN['g_delete_own_topics'],
							 'g_post_polls'         => $IN['g_post_polls'],
							 'g_vote_polls'         => $IN['g_vote_polls'],
							 'g_use_pm'             => $IN['g_use_pm'],
							 'g_is_supmod'          => $IN['g_is_supmod'],
							 'g_access_cp'          => $IN['g_access_cp'],
							 'g_title'              => trim($IN['g_title']),
							 'g_can_remove'         => $IN['g_can_remove'],
							 'g_append_edit'        => $IN['g_append_edit'],
							 'g_access_offline'     => $IN['g_access_offline'],
							 'g_avoid_q'            => $IN['g_avoid_q'],
							 'g_avoid_flood'        => $IN['g_avoid_flood'],
							 'g_icon'               => trim($IN['g_icon']),
							 'g_attach_max'         => $IN['g_attach_max'],
							 'g_avatar_upload'      => $IN['g_avatar_upload'],
							 'g_calendar_post'      => $IN['g_calendar_post'],
							 'g_max_messages'       => $IN['g_max_messages'],
							 'g_max_mass_pm'        => $IN['g_max_mass_pm'],
							 'g_search_flood'       => $IN['g_search_flood'],
							 'prefix'               => $prefix,
							 'suffix'               => $suffix,
							 'g_promotion'          => $promotion_a.'&'.$promotion_b,
							 'g_hide_from_list'     => $IN['g_hide_from_list'],
							 'g_post_closed'        => $IN['g_post_closed'],
							 'g_sale_post'          => $IN['g_sale_post'], /*hack*/ 
							 'g_perm_id'			=> $perm_id,
							 'g_photo_max_vars'	    => $IN['p_max'].':'.$IN['p_width'].':'.$IN['p_height'],
							 'g_dohtml'			    => $IN['g_dohtml'],
							 'g_edit_topic'			=> $IN['g_edit_topic'],
							 'g_email_limit'		=> intval($IN['join_limit']).':'.intval($IN['join_flood']),
							 
						  );
						  
		if ($type == 'edit')
		{
			$rstring = $DB->compile_db_update_string( $db_string );
			
			$DB->query("UPDATE ibf_groups SET $rstring WHERE g_id='".$IN['id']."'");
			
			// Update the title of the group held in the mod table incase it changed.
			
			$DB->query("UPDATE ibf_moderators SET group_name='".trim($IN['g_title'])."' WHERE group_id='".$IN['id']."'");
			
			$ADMIN->save_log("༭Ⱥ '{$IN['g_title']}'");
			
			$ADMIN->done_screen("Ⱥѱ༭", "Ⱥ", "act=group" );
			
		}
		else
		{
			$rstring = $DB->compile_db_insert_string( $db_string );
			
			$DB->query("INSERT INTO ibf_groups (" .$rstring['FIELD_NAMES']. ") VALUES (". $rstring['FIELD_VALUES'] .")");
			
			$ADMIN->save_log("Ⱥ '{$IN['g_title']}'");
			
			$ADMIN->done_screen("Ⱥ", "Ⱥ", "act=group" );
		}
	}
	
	function clean_perms($str)
	{
		$str = preg_replace( "/,$/", "", $str );
		$str = str_replace(  ",,", ",", $str );
		
		return $str;
	}
	
	//+---------------------------------------------------------------------------------
	//
	// Add / edit group
	//
	//+---------------------------------------------------------------------------------
	
	function group_form($type='edit')
	{
		global $IN, $INFO, $DB, $SKIN, $ADMIN, $std, $MEMBER, $GROUP;
		
		$all_groups = array( 0 => array ('none', 'Ҫ') );
		
		if ($type == 'edit')
		{
			if ($IN['id'] == "")
			{
				$ADMIN->error("ϿûпѡȺ id.");
			}
			
			if ( $INFO['admin_group'] == $IN['id'] )
			{
				if ( $MEMBER['mgroup'] != $INFO['admin_group'] )
				{
					$ADMIN->error("Ǹܱ༭߹Ⱥ顣");
				}
			}
			
			$form_code = 'doedit';
			$button    = 'ɱ༭';
				
		}
		else
		{
			$form_code = 'doadd';
			$button    = 'Ⱥ';
		}
		
		if ($IN['id'] != "")
		{
			$DB->query("SELECT * FROM ibf_groups WHERE g_id='".$IN['id']."'");
			$group = $DB->fetch_row();
			
			$query = "SELECT g_id, g_title FROM ibf_groups WHERE g_id <> {$IN['id']} ORDER BY g_title";
		}
		else
		{
			$group = array();
			
			$query = "SELECT g_id, g_title FROM ibf_groups ORDER BY g_title";
		}
		
		//-------------------------------------------
		// sort out the promotion stuff
		//-------------------------------------------
		
		list($group['g_promotion_id'], $group['g_promotion_posts']) = explode( '&', $group['g_promotion'] );
		
		if ($group['g_promotion_posts'] < 1)
		{
			$group['g_promotion_posts'] = '';
		}
		
		$DB->query($query);
		
		while ( $r = $DB->fetch_row() )
		{
			if ( $r['g_id'] == $INFO['admin_group'] )
			{
				continue;
			}
			
			$all_groups[] = array( $r['g_id'], $r['g_title'] );
		}
		
		//-------------------------------------------
		
		$perm_masks = array();
		
		$DB->query("SELECT * FROM ibf_forum_perms");
		
		while ( $r = $DB->fetch_row() )
		{
			$perm_masks[] = array( $r['perm_id'], $r['perm_name'] );
		}
		
		//-------------------------------------------
		
		if ($type == 'edit')
		{
			$ADMIN->page_title = "༭ʹȺ ".$group['g_title'];
		}
		else
		{
			$ADMIN->page_title = 'һʹȺ';
			$group['g_title'] = 'Ⱥ';
		}
		
		$guest_legend = "";
		
		if ($group['g_id'] == $INFO['guest_group'])
		{
			$guest_legend = "</b><br><i>(ڷÿ)</i>";
		}
		
		$ADMIN->page_detail = "ͳ֮ǰϸ";
		
		
		//+-------------------------------
		
		$ADMIN->html .= "<script language='javascript'>
						 <!--
						  function checkform() {
						  
						  	isAdmin = document.forms[0].g_access_cp;
						  	isMod   = document.forms[0].g_is_supmod;
						  	
						  	msg = '';
						  	
						  	if (isAdmin[0].checked == true)
						  	{
						  		msg += 'ȺĻԱԽ̨\\n\\n';
						  	}
						  	
						  	if (isMod[0].checked == true)
						  	{
						  		msg += 'ȺĻԱǳ\\n\\n';
						  	}
						  	
						  	if (msg != '')
						  	{
						  		msg = 'ȫ\\n--------------\\nԱȺƣ ' + document.forms[0].g_title.value + '\\n--------------\\n\\n' + msg + 'ȷ';
						  		
						  		formCheck = confirm(msg);
						  		
						  		if (formCheck == true)
						  		{
						  			return true;
						  		}
						  		else
						  		{
						  			return false;
						  		}
						  	}
						  }
						 //-->
						 </script>\n";
		
		$ADMIN->html .= $SKIN->start_form( array( 1 => array( 'code'  , $form_code  ),
												  2 => array( 'act'   , 'group'     ),
												  3 => array( 'id'    , $IN['id']   ),
									     ) , 'adform', "onSubmit='return checkform()'" );
									     
		
		list($p_max, $p_width, $p_height) = explode( ":", $group['g_photo_max_vars'] );
		
		//+-------------------------------
		
		$SKIN->td_header[] = array( "&nbsp;"  , "40%" );
		$SKIN->td_header[] = array( "&nbsp;"  , "60%" );
		
		//+-------------------------------
		
		$prefix = preg_replace( "/'/", "'", $group['prefix'] );
		$prefix = preg_replace( "/</", "&lt;" , $prefix          );
		$suffix = preg_replace( "/'/", "'", $group['suffix'] );
		$suffix = preg_replace( "/</", "&lt;" , $suffix          );
		
		$ADMIN->html .= $SKIN->start_table( "趨", "Ⱥ趨" );
		
		$ADMIN->html .= $SKIN->add_td_row( array( "<b>Ⱥ</b>" ,
												  $SKIN->form_input("g_title", $group['g_title'] )
									     )      );
									     
		//+-------------------------------
		// Sort out default array
		//+-------------------------------
		
		$ADMIN->html .=
		"<script type='text/javascript'>
			
			var show   = '';
		";
		
		foreach ($perm_masks as $id => $d)
		{
			$ADMIN->html .= " 		perms_$d[0] = '$d[1]';\n";
		}
		
		$ADMIN->html .=
		"	
			var show = '';
			
		 	function saveit(f)
		 	{
		 		show = '';
		 		
		 		for (var i = 0 ; i < f.options.length; i++)
				{
					if (f.options[i].selected)
					{
						tid  = f.options[i].value;
						show += '\\n' + eval('perms_'+tid);
					}
				}
			}
			
			function show_me()
			{
				if (show == '')
				{
					show = 'δ⵽ı\\n㰴ѡ񷽿';
				}
				
				alert('ѡȨ趨\\n---------------------------------\\n' + show);
			}
			
		</script>";
		
		$arr = explode( ",", $group['g_perm_id'] );
									     
		$ADMIN->html .= $SKIN->add_td_row( array( "<b>ʹȨ޴ȡ...</b><br>ѡһ" ,
												  $SKIN->form_multiselect("permid[]", $perm_masks, $arr, 5, 'onfocus="saveit(this)"; onchange="saveit(this)";' )."<a href='javascript:show_me();'>ʾѡ趨</a>"
									     )      );
									     
		$ADMIN->html .= $SKIN->add_td_row( array( "<b>Ⱥͼʾ</b><br>(ʡ)" ,
												  $SKIN->form_input("g_icon", $group['g_icon'] )
									     )      );
		
		$ADMIN->html .= $SKIN->add_td_row( array( "<b>ϴС (KB)</b>".$SKIN->js_help_link('mg_upload')."<br>(Ҫֹϴ)" ,
												  $SKIN->form_input("g_attach_max", $group['g_attach_max'] )
									     )      );
									     
		$ADMIN->html .= $SKIN->add_td_row( array( "<b>ƬϴС (KB)</b><br>(Ҫֹϴ)" ,
												  $SKIN->form_input("p_max", $p_max )."<br />"
												  ." (px): <input type='text' size='3' name='p_width' value='{$p_width}'> "
												  ."߶ (px): <input type='text' size='3' name='p_height' value='{$p_height}'>"
									     )      );
									     
		$ADMIN->html .= $SKIN->add_td_row( array( "<b>бʽ []</b><br>()<br>(&lt;span style='color:red'&gt;)" ,
												  $SKIN->form_input("prefix", $prefix )
									     )      );
									     
		$ADMIN->html .= $SKIN->add_td_row( array( "<b>бʽ [β]</b><br>()<br>(&lt;/span&gt;)" ,
												  $SKIN->form_input("suffix", $suffix )
									     )      );
									     
		$ADMIN->html .= $SKIN->add_td_row( array( "<b>ӻԱбȺ飿</b>" ,
												  $SKIN->form_yes_no("g_hide_from_list", $group['g_hide_from_list'] )
									     )      );
									     
		$ADMIN->html .= $SKIN->end_table();
		
		//+-------------------------------
		
		$SKIN->td_header[] = array( "&nbsp;"  , "40%" );
		$SKIN->td_header[] = array( "&nbsp;"  , "60%" );
		
		//+-------------------------------
		
		$ADMIN->html .= $SKIN->start_table( "Ȩ", "ƴȺʹ" );
		
		$ADMIN->html .= $SKIN->add_td_row( array( "<b>̳</b>" ,
												  $SKIN->form_yes_no("g_view_board", $group['g_view_board'] )
									     )      );
									     
		$ADMIN->html .= $SKIN->add_td_row( array( "<b>رյ̳</b>" ,
												  $SKIN->form_yes_no("g_access_offline", $group['g_access_offline'] )
									     )      );
		
		$ADMIN->html .= $SKIN->add_td_row( array( "<b>ԼӻԱϼԱб</b>" ,
												  $SKIN->form_yes_no("g_mem_info", $group['g_mem_info'] )
									     )      );
									     
		$ADMIN->html .= $SKIN->add_td_row( array( "<b>ԹۿԱ⣿</b>" ,
												  $SKIN->form_yes_no("g_other_topics", $group['g_other_topics'] )
									     )      );
									     
		$ADMIN->html .= $SKIN->add_td_row( array( "<b>ʹ</b>" ,
												  $SKIN->form_yes_no("g_use_search", $group['g_use_search'] )
									     )      );
									     
		$ADMIN->html .= $SKIN->add_td_row( array( "<b>ˮ</b><br>ֹͣ 0 ղˮ" ,
												  $SKIN->form_input("g_search_flood", $group['g_search_flood'] )
									     )      );							     
									     
		list( $limit, $flood ) = explode( ":", $group['g_email_limit'] );					     
									     
		$ADMIN->html .= $SKIN->add_td_row( array( "<b>ɴ̳ŸԱ</b><br />λջȡ $guest_legend</b>" ,
												  $SKIN->form_yes_no("g_email_friend", $group['g_email_friend'] )
												 ."<br /> ". $SKIN->form_simple_input("join_limit", $limit, 2 )." ʼ 24 Сʱ֮"
												 ."<br />...ÿʼ ".$SKIN->form_simple_input("join_flood", $flood, 2 )." "
									     )      );
									     
		$ADMIN->html .= $SKIN->add_td_row( array( "<b>Ա༭Լĸϣ$guest_legend" ,
												  $SKIN->form_yes_no("g_edit_profile", $group['g_edit_profile'] )
									     )      );							     
									     
		$ADMIN->html .= $SKIN->add_td_row( array( "<b>ʹ PM ϵͳ$guest_legend" ,
												  $SKIN->form_yes_no("g_use_pm", $group['g_use_pm'] )
									     )      );
									     
		$ADMIN->html .= $SKIN->add_td_row( array( "<b> PM ?$guest_legend<br>( 0 սֹ PM)" ,
												  $SKIN->form_input("g_max_mass_pm", $group['g_max_mass_pm'] )
									     )      );
									     
		$ADMIN->html .= $SKIN->add_td_row( array( "<b>ɴѶϢ$guest_legend" ,
												  $SKIN->form_input("g_max_messages", $group['g_max_messages'] )
									     )      );
									     						     							     
		$ADMIN->html .= $SKIN->add_td_row( array( "<b>ϴͼƬ$guest_legend" ,
												  $SKIN->form_yes_no("g_avatar_upload", $group['g_avatar_upload'] )
									     )      );
									     
		$ADMIN->html .= $SKIN->end_table();
		
		//+-------------------------------
		
		$SKIN->td_header[] = array( "&nbsp;"  , "40%" );
		$SKIN->td_header[] = array( "&nbsp;"  , "60%" );
		
		//+-------------------------------
		
		$ADMIN->html .= $SKIN->start_table( "Ȩ", "ƴȺɷĵط" );

		$ADMIN->html .= $SKIN->add_td_row( array( "<b>ۼ<br>0հױʾܣ</b>" ,
												  $SKIN->form_input("g_sale_post", $group['g_sale_post'] )
									     )      );
		
		$ADMIN->html .= $SKIN->add_td_row( array( "<b>Է (ĵط)</b>" ,
												  $SKIN->form_yes_no("g_post_new_topics", $group['g_post_new_topics'] )
									     )      );
		
		$ADMIN->html .= $SKIN->add_td_row( array( "<b>ԻظԼ⣿</b>" ,
												  $SKIN->form_yes_no("g_reply_own_topics", $group['g_reply_own_topics'] )
									     )      );
		
		$ADMIN->html .= $SKIN->add_td_row( array( "<b>ԻظԱ (ĵط)</b>" ,
												  $SKIN->form_yes_no("g_reply_other_topics", $group['g_reply_other_topics'] )
									     )      );
		
		$ADMIN->html .= $SKIN->add_td_row( array( "<b>Ա༭Լ£$guest_legend" ,
												  $SKIN->form_yes_no("g_edit_posts", $group['g_edit_posts'] )
									     )      );
									     
		$ADMIN->html .= $SKIN->add_td_row( array( "<b>༭ʱ ()$guest_legend<br>趨ʱЧܾʹ߱༭ջ 0 ơ" ,
												  $SKIN->form_input("g_edit_cutoff", $group['g_edit_cutoff'] )
									     )      );
									     
		$ADMIN->html .= $SKIN->add_td_row( array( "<b>ʹƳ 'Edited by' עţ$guest_legend</b>" ,
												  $SKIN->form_yes_no("g_append_edit", $group['g_append_edit'] )
									     )      );							     
									     
		$ADMIN->html .= $SKIN->add_td_row( array( "<b>ɾԼ£$guest_legend" ,
												  $SKIN->form_yes_no("g_delete_own_posts", $group['g_delete_own_posts'] )
									     )      );
									     						     
		$ADMIN->html .= $SKIN->add_td_row( array( "<b>Կ/رԼ⣿$guest_legend" ,
												  $SKIN->form_yes_no("g_open_close_posts", $group['g_open_close_posts'] )
									     )      );							     
		
		$ADMIN->html .= $SKIN->add_td_row( array( "<b>Ա༭Լı & $guest_legend" ,
												  $SKIN->form_yes_no("g_edit_topic", $group['g_edit_topic'] )
									     )      );
									     
		$ADMIN->html .= $SKIN->add_td_row( array( "<b>ɾԼ⣿$guest_legend" ,
												  $SKIN->form_yes_no("g_delete_own_topics", $group['g_delete_own_topics'] )
									     )      );
		
		$ADMIN->html .= $SKIN->add_td_row( array( "<b>ԷͶƱ (ĵط)$guest_legend</b>" ,
												  $SKIN->form_yes_no("g_post_polls", $group['g_post_polls'] )
									     )      );
									     
		$ADMIN->html .= $SKIN->add_td_row( array( "<b>ԲͶƱ (ĵط)$guest_legend" ,
												  $SKIN->form_yes_no("g_vote_polls", $group['g_vote_polls'] )
									     )      );							     
									     
		$ADMIN->html .= $SKIN->add_td_row( array( "<b>ˮƣ</b>" ,
												  $SKIN->form_yes_no("g_avoid_flood", $group['g_avoid_flood'] )
									     )      );
									     
		$ADMIN->html .= $SKIN->add_td_row( array( "<b>У</b>" ,
												  $SKIN->form_yes_no("g_avoid_q", $group['g_avoid_q'] )
									     )      );
									     
		$ADMIN->html .= $SKIN->add_td_row( array( "<b>Լ¼$guest_legend</b>" ,
												  $SKIN->form_yes_no("g_calendar_post", $group['g_calendar_post'] )
									     )      );
									     					     							     
		$ADMIN->html .= $SKIN->add_td_row( array( "<b>ʹ [doHTML] ǩ$guest_legend</b><br />".$SKIN->js_help_link('mg_dohtml') ,
												  $SKIN->form_yes_no("g_dohtml", $group['g_dohtml'] )
									     )      );
		
		$ADMIN->html .= $SKIN->end_table();
		
		//+-------------------------------
		
		$SKIN->td_header[] = array( "&nbsp;"  , "40%" );
		$SKIN->td_header[] = array( "&nbsp;"  , "60%" );
		
		//+-------------------------------
		
		$ADMIN->html .= $SKIN->start_table( "Ȩ", "ܾȺĹ" );
		
		$ADMIN->html .= $SKIN->add_td_row( array( "<b>ǷΪ (Թκεط)$guest_legend" ,
												  $SKIN->form_yes_no("g_is_supmod", $group['g_is_supmod'] )
									     )      );
		
		$ADMIN->html .= $SKIN->add_td_row( array( "<b>Խ̨$guest_legend" ,
												  $SKIN->form_yes_no("g_access_cp", $group['g_access_cp'] )
									     )      );
									     
		$ADMIN->html .= $SKIN->add_td_row( array( "<b>Ⱥ 'ر' з" ,
												  $SKIN->form_yes_no("g_post_closed", $group['g_post_closed'] )
									     )      );
									     
		$ADMIN->html .= $SKIN->end_table();
		
		//+-------------------------------
		
		$SKIN->td_header[] = array( "&nbsp;"  , "40%" );
		$SKIN->td_header[] = array( "&nbsp;"  , "60%" );
		
		//+-------------------------------
		
		$ADMIN->html .= $SKIN->start_table( "Ⱥ" );
		
		if ($group['g_id'] == $INFO['admin_group'])
		{
			$ADMIN->html .= $SKIN->add_td_row( array( "<b>ѡ 'Ҫ' ȡ</b><br>".$SKIN->js_help_link('mg_promote') ,
													  "߹Ⱥ˹ЧϾ - Ѿڲ廹ܽȥ"
											 )      );
		}
		else
		{
			$ADMIN->html .= $SKIN->add_td_row( array( "<b>ѡ 'Ҫ' ȡ</b>$guest_legend<br>".$SKIN->js_help_link('mg_promote') ,
													  'ȺĻԱ '.$SKIN->form_dropdown("g_promotion_id", $all_groups, $group['g_promotion_id'] )
													 .'<br>Ǵﵽ '.$SKIN->form_simple_input('g_promotion_posts', $group['g_promotion_posts'] ).' ƪ'
											 )      );
		}
		
		
		$ADMIN->html .= $SKIN->end_form($button);
										 
		$ADMIN->html .= $SKIN->end_table();
		
		$ADMIN->output();
			
			
	}

	//+---------------------------------------------------------------------------------
	//
	// Show "Management Screen
	//
	//+---------------------------------------------------------------------------------
	
	function main_screen()
	{
		global $IN, $INFO, $DB, $SKIN, $ADMIN, $std, $MEMBER, $GROUP;
		
		$ADMIN->page_title = "ʹȺ";
		
		$ADMIN->page_detail = "ʹ߱һֿ١ǿ֯Աʽ 4 ԤȺǲƳ (֤ÿ͡ԱԱ)ı༭ǡٸʹ߱ĺһ '' Ⱥ飬ǴȡĳЩȺ޷<br>Ȩ޿ٵıȺȡд뼰ظ趨ÿһ趨";
		
		$g_array = array();
		
		$SKIN->td_header[] = array( "Ⱥ"    , "30%" );
		$SKIN->td_header[] = array( "ȡ ACP"    , "15%" );
		$SKIN->td_header[] = array( ""     , "15%" );
		$SKIN->td_header[] = array( "Ա"        , "10%" );
		$SKIN->td_header[] = array( "༭Ⱥ"     , "20%" );
		$SKIN->td_header[] = array( "ɾ"         , "10%" );
		
		//+-------------------------------
		
		$ADMIN->html .= $SKIN->start_table( "ʹȺ" );
		
		$DB->query("SELECT ibf_groups.g_id, ibf_groups.g_access_cp, ibf_groups.g_is_supmod, ibf_groups.g_title,ibf_groups.prefix, ibf_groups.suffix, COUNT(ibf_members.uid) as count FROM ibf_groups "
		          ."LEFT JOIN ibf_members ON (ibf_members.mgroup = ibf_groups.g_id) "
		          ."GROUP BY ibf_groups.g_id ORDER BY ibf_groups.g_title");
		
		while ( $r = $DB->fetch_row() )
		{
		
			$del  = "";
			$mod  = '&nbsp;';
			$adm  = '&nbsp;';
			
			if ($r['g_id'] > 4)
			{
				$del = "<center><a href='{$ADMIN->base_url}&act=group&code=delete&id=".$r['g_id']."'>ɾ</a></center>";
			}
			//-----------------------------------
			if ($r['g_access_cp'] == 1)
			{
				$adm = '<center><span style="color:red"></span></center>';
			}
			//-----------------------------------
			if ($r['g_is_supmod'] == 1)
			{
				$mod = '<center><span style="color:red"></span></center>';
			}

			if ($r['g_id'] != 1 and $r['g_id'] != 2)
			{
				$total_linkage = "<a href='{$INFO['board_url']}/index.{$INFO['php_ext']}?act=Members&max_results=30&filter={$r['g_id']}&sort_order=asc&sort_key=name&st=0' target='_blank' title='List Users'>".$r['prefix'].$r['g_title'].$r['suffix']."</a>";
			}
			else
			{
				$total_linkage = $r['prefix'].$r['g_title'].$r['suffix'];
			}
			
			if ( $INFO['admin_group'] == $r['g_id'] )
			{
				$is_root = " ( ROOT )";
			}
			else
			{
				$is_root = "";
			}
			
			$ADMIN->html .= $SKIN->add_td_row( array( "<b>$total_linkage</b> $is_root" ,
												      $adm,
												      $mod,
												      "<center>".$r['count']."</center>",
												      "<center><a href='{$ADMIN->base_url}&act=group&code=edit&id=".$r['g_id']."'>༭Ⱥ</a></center>",
												      $del
												      
									     )      );
									     
			$g_array[] = array( $r['g_id'], $r['g_title'] );
		}
		
		$ADMIN->html .= $SKIN->add_td_basic("&nbsp;", "center", "title");

		$ADMIN->html .= $SKIN->end_table();
		
		//+-------------------------------
		
		$ADMIN->html .= $SKIN->start_form( array( 1 => array( 'code'  , 'add' ),
												  2 => array( 'act'   , 'group'     ),
									     )      );
									     
		//+-------------------------------
		
		$SKIN->td_header[] = array( "&nbsp;"  , "40%" );
		$SKIN->td_header[] = array( "&nbsp;"  , "60%" );
		
		//+-------------------------------
		
		$ADMIN->html .= $SKIN->start_table( "һԱȺ" );
		
		$ADMIN->html .= $SKIN->add_td_row( array( "<b>Ⱥ...</b>" ,
												  $SKIN->form_dropdown("id", $g_array, 3 )
									     )      );
									     
		$ADMIN->html .= $SKIN->end_form("趨Ⱥ");
										 
		$ADMIN->html .= $SKIN->end_table();
		
		$ADMIN->output();
		
		
	}
	
		
}


?>
